/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockRitualStone;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.ritual.CapabilityRuneType;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IRitualStone;
import wayoftime.bloodmagic.ritual.IRitualStoneTile;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;

public class RitualHelper {
    public static boolean canCrystalActivate(Ritual ritual, int crystalLevel) {
        return ritual.getCrystalLevel() <= crystalLevel && BloodMagic.RITUAL_MANAGER.enabled(BloodMagic.RITUAL_MANAGER.getId(ritual), false);
    }

    public static String getValidRitual(Level world, BlockPos pos) {
        for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
            for (int i = 0; i < 4; ++i) {
                Direction direction = Direction.m_122407_((int)i);
                if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
                return BloodMagic.RITUAL_MANAGER.getId(ritual);
            }
        }
        return "";
    }

    public static Direction getDirectionOfRitual(Level world, BlockPos pos, Ritual ritual) {
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.m_122407_((int)i);
            if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
            return direction;
        }
        return null;
    }

    public static boolean checkValidRitual(Level world, BlockPos pos, Ritual ritual, Direction direction) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            BlockPos newPos = pos.m_141952_((Vec3i)component.getOffset(direction));
            if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRuneType(Level world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return false;
        }
        Block block = world.m_8055_(pos).m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        if (block instanceof IRitualStone) {
            return ((IRitualStone)block).isRuneType(world, pos, type);
        }
        if (tile instanceof IRitualStoneTile) {
            return ((IRitualStoneTile)tile).isRuneType(type);
        }
        if (tile != null && tile.getCapability(CapabilityRuneType.INSTANCE, null).isPresent()) {
            return ((CapabilityRuneType)tile.getCapability(CapabilityRuneType.INSTANCE, null).resolve().get()).isRuneType(type);
        }
        return false;
    }

    public static boolean isRune(Level world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        Block block = world.m_8055_(pos).m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        if (block instanceof IRitualStone) {
            return true;
        }
        if (tile instanceof IRitualStoneTile) {
            return true;
        }
        return tile != null && tile.getCapability(CapabilityRuneType.INSTANCE, null).isPresent();
    }

    public static void setRuneType(Level world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        BlockEntity tile = world.m_7702_(pos);
        if (state.m_60734_() instanceof IRitualStone) {
            ((IRitualStone)state.m_60734_()).setRuneType(world, pos, type);
        } else if (tile instanceof IRitualStoneTile) {
            ((IRitualStoneTile)tile).setRuneType(type);
        } else {
            LazyOptional cap = tile.getCapability(CapabilityRuneType.INSTANCE, null);
            if (cap.isPresent()) {
                ((CapabilityRuneType)cap.resolve().get()).setRuneType(type);
                world.m_7260_(pos, state, state, 3);
            }
        }
    }

    public static boolean createRitual(Level world, BlockPos pos, Direction direction, Ritual ritual, boolean safe) {
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        BlockState mrs = ((Block)BloodMagicBlocks.MASTER_RITUAL_STONE.get()).m_49966_();
        world.m_46597_(pos, mrs);
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static boolean abortConstruction(Level world, BlockPos pos, Direction direction, boolean safe, List<RitualComponent> components) {
        for (RitualComponent component : components) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.m_141952_((Vec3i)offset);
            if (!world.m_151570_(newPos) && (!safe || world.m_46859_(newPos))) continue;
            return true;
        }
        return false;
    }

    public static boolean repairRitualFromRuins(TileMasterRitualStone tile, boolean safe) {
        Direction direction;
        Ritual ritual = tile.getCurrentRitual();
        if (ritual == null) {
            Pair<Ritual, Direction> pair = RitualHelper.getRitualFromRuins(tile);
            ritual = (Ritual)pair.getKey();
            direction = (Direction)pair.getValue();
        } else {
            direction = tile.getDirection();
        }
        Level world = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static void setRitualStones(Direction direction, Level world, BlockPos pos, List<RitualComponent> gatheredComponents) {
        for (RitualComponent component : gatheredComponents) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.m_141952_((Vec3i)offset);
            ((BlockRitualStone)BloodMagicBlocks.BLANK_RITUAL_STONE.get()).setRuneType(world, newPos, component.getRuneType());
        }
    }

    public static Pair<Ritual, Direction> getRitualFromRuins(TileMasterRitualStone tile) {
        BlockPos pos = tile.m_58899_();
        Level world = tile.m_58904_();
        Ritual possibleRitual = tile.getCurrentRitual();
        Direction possibleDirection = tile.getDirection();
        int highestCount = 0;
        if (possibleRitual == null || possibleDirection == null) {
            for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
                for (int i = 0; i < 4; ++i) {
                    Direction direction = Direction.m_122407_((int)i);
                    ArrayList components = Lists.newArrayList();
                    ritual.gatherComponents(components::add);
                    int currentCount = 0;
                    for (RitualComponent component : components) {
                        BlockPos newPos = pos.m_141952_((Vec3i)component.getOffset(direction));
                        if (!RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
                        ++currentCount;
                    }
                    if (currentCount <= highestCount) continue;
                    highestCount = currentCount;
                    possibleRitual = ritual;
                    possibleDirection = direction;
                }
            }
        }
        return Pair.of((Object)possibleRitual, (Object)possibleDirection);
    }

    public static Tuple<Integer, Map<EnumRuneType, Integer>> countRunes(Ritual ritual) {
        EnumMap<EnumRuneType, Integer> runeMap = new EnumMap<EnumRuneType, Integer>(EnumRuneType.class);
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        int totalRunes = components.size();
        for (RitualComponent component : components) {
            runeMap.compute(component.getRuneType(), (k, v) -> v == null ? 1 : v + 1);
        }
        return new Tuple((Object)totalRunes, runeMap);
    }
}

